/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved. 
 * 
 * NOTICE:  All information contained herein is, and remains  
 * the property of Adobe Systems Incorporated and its suppliers, 
 * if any.  The intellectual and technical concepts contained 
 * herein are proprietary to Adobe Systems Incorporated and its 
 * suppliers and are protected by trade secret or copyright law. 
 * Dissemination of this information or reproduction of this material 
 * is strictly forbidden unless prior written permission is obtained 
 * from Adobe Systems Incorporated. 
 **************************************************************************/ 
/* ******************************************** GLOBAL VARIABLES **************************************** */


/* *********************************************  OnOpen Function ***************************************** */
var gProtoProjectDoc  = new Array();
var proCount =0;
var bIsFunctionAlreadyRegistered = new Boolean(false);
function CloseProtoDocument()
{
	dw.revokeIdleHandler("CloseProtoDocument");
	bIsFunctionAlreadyRegistered = false;
	proCount = 0;
	if(gProtoProjectDoc.length == 0)
		return;
	var protoOpenedDoc = gProtoProjectDoc;
	gProtoProjectDoc = new Array();
	
	for(var i =0; i< protoOpenedDoc.length; i++)
	{	
		dw.setActiveWindow(protoOpenedDoc[i]);
		dw.closeDocument(protoOpenedDoc[i]);
	}
	
}
function registerIdleHandler(dompro)
{
	gProtoProjectDoc[proCount++] = dompro;
	if(bIsFunctionAlreadyRegistered == false){
	  dw.registerIdleHandler("CloseProtoDocument", function() { CloseProtoDocument();}, 1);
	  bIsFunctionAlreadyRegistered = true;
	}
}
function onOpen() 
{
  var filePath = "";
  var  src, metafile;	
  var filename = "";
  try{
		filename  = dw.getDocumentDOM().URL;
	}
  catch(err){
		
	// do nothing
  }
	if(filename.substr(filename.length-4) == ".pro")
	{
		var dompro = dw.getDocumentDOM();
		/* The pro window should be closed all the time so moving this to the top */
		registerIdleHandler(dompro);
		var htmlurl = extractProtoProject(filename);
		if(!htmlurl)
		{
			alert(dw.loadString("protoDWExt/zipExtractionFail"));
			return;
		}
		var siteurl = CreateSteFile(htmlurl);
		if(siteurl == "")
		{
			alert(dw.loadString("protoDWExt/newSiteFail"));
			return;
		}
			
		dompro.setView("split");
		//setTimeout('CloseProtoDocument()',1000);
		
		//dw.releaseDocument(dompro);
		/*  Import the site into dreamweaver and expand it  and open the Index.html*/		
		if(!site.importSite(siteurl))
		{
			alert(dw.loadString("protoDWExt/siteImportFail"));
			return;
		}
        /* We need to pass an array of url to the setSelection() function*/
		var finalIndexHTMLPath = htmlurl + "/Index.html";
        var indexFileName =  new Array();
        indexFileName[0] = finalIndexHTMLPath;
        site.setSelection(indexFileName);
//		site.open();
		var newProtoIndexDoc = dw.openDocument(finalIndexHTMLPath);
		if(!newProtoIndexDoc)
		{
			alert(dw.loadString("protoDWExt/indexHTMLLoadFail"));
		}
		else
		{
			newProtoIndexDoc.setDesignViewMode("live");
		}
		/* Delete the ste file created */
		DWfile.remove(siteurl);
	}
}


//********************************************* LOCAL FILES *************************************************
function extractProtoProject(filename)
{
		var filepath = MMNotes.localURLToFilePath(filename);
		var htmlfileName = "";
		var htmlurl = "";
		try{
			htmlfileName = AdobeProtoDWExt.OpenProtoProject(filepath);
			htmlurl = MMNotes.filePathToLocalURL(htmlfileName);
		}
		catch(err){
			htmlurl = 0;
		}
		return htmlurl;
}

/*  Currently the ste name is always c:/temp/mydata sice we have an intension to delete it (There should not be any space in site name) */
function CreateSteFile(htmlurl)
{
		var PLATFORM = navigator.platform;
		var FILE_SEPARATOR = (PLATFORM == "Win32") ? "\\" : ":";
		var projectName =  htmlurl.substr(htmlurl.lastIndexOf("/") + 1);
		var rootFolderurl  = htmlurl;
		var sitename = rootFolderurl + projectName + ".ste";
		var siteurl = dreamweaver.getTempFolderPath() + "/Protosite.ste";
		var writeSucessFlag = true;
		var filepath = MMNotes.localURLToFilePath(rootFolderurl)  + FILE_SEPARATOR;
		var rootFolderPath = encodeURI(filepath);
		var siteText = "<?xml version=\"1.0\" encoding=\"utf-8\" ?> \n<site>\n\t <localinfo sitename=\""+projectName+"\" localroot=\""+ rootFolderPath + "\"/> \n</site>";
		//alert(siteText);
		writeSucessFlag = DWfile.write(siteurl,siteText);
		if(! writeSucessFlag)
		{
			siteurl = "";
		}
		return siteurl;
}
